﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //PobierzDane();
    }

    #region Testowanie LINQ to SQL
    private void PobierzDane()
    {
        ListaMailowaDataContext bazaDanych = new ListaMailowaDataContext();
        var tabela = bazaDanych.ListaAdresows;

        //pobieranie kolekcji
        var listaAdresowPl = from adres in tabela where adres.Email.EndsWith(".pl") select adres;

        //wyświetlanie pobranej kolekcji
        string s = "Lista adresów z polski:<BR><FONT COLOR='navy'>";
        foreach (ListaAdresow adres in listaAdresowPl)
            s += adres.Email + "<BR>";
        s += "</FONT>";
        Label1.Text += s.Replace("@", "<FONT COLOR='black'>@</FONT>") + "<P>";

        //informacje o pobranych danych
        Label1.Text += "Typ: " + listaAdresowPl.GetType().FullName + "<BR>";
        Label1.Text += "Ilość pobranych rekordów: " + listaAdresowPl.Count().ToString() + "<BR>";
    }
    #endregion

    protected void Button1_Click(object sender, EventArgs e)
    {
        ListaMailowaDataContext bazaDanych = new ListaMailowaDataContext();
        var tabela = bazaDanych.ListaAdresows;

        //dodawanie lub usuwanie adresu do kolekcji
        string komunikat = null;
        if (sender == Button1)
        {
            ListaAdresow nowyAdres = new ListaAdresow() { Email = TextBox1.Text };
            tabela.InsertOnSubmit(nowyAdres);
            komunikat = "dodałem do";
        }
        if (sender == Button2)
        {
            ListaAdresow kasowanyAdres = tabela.Single(adres => adres.Email == TextBox1.Text);
            tabela.DeleteOnSubmit(kasowanyAdres);
            komunikat = "usunąłem z";
        }

        //wysylanie zmian
        string data = DateTime.Now.ToLongDateString() + ", " + DateTime.Now.ToLongTimeString() + ": ";
        try
        {
            bazaDanych.SubmitChanges();
            Label1.Text += data + komunikat + " listy adres e-mail: " + TextBox1.Text + "<BR>";
            TextBox1.Text = "";
        }
        catch (Exception exc)
        {
            if ((exc.GetType().FullName == "System.Data.SqlClient.SqlException") && ((System.Data.SqlClient.SqlException)exc).Number == 2627)
                Label1.Text += data + "<FONT COLOR=navy>Podany adres e-mail znajduje się już na liście</FONT><BR>";
            else
                Label1.Text += data + "<FONT COLOR=red>" + exc.Message + "</FONT><BR>";
        }
    }
}
